//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection; 
   float4x4 World:World;  
   float4x4 OrthoProj;
   float4x4 ViewInv:ViewInverse; 

//--------------
// tweaks
//--------------
   float3 vColor={0.1,0.1,0.1};
   float GridSize=25.0;
   float Thickness;
   float ThicknessDepth;

//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler Base = sampler_state 
      {
 	texture = <BaseTX>;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
        ADDRESSW=Clamp;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
	float2 Tex:TEXCOORD0;
	float3 Normal:NORMAL; 
     };
   struct OutPut
     {
	float4 Pos:POSITION;
	float4 Grid:TEXCOORD0;
	float3 Box:TEXCOORD1;
   	float2 Tex:TEXCOORD2;
 	float3 Normal:TEXCOORD3;
 	float3 vPos:TEXCOORD4;
	float4 Circle:TEXCOORD5;
     };
 
//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=mul(mul(IN.Pos,World),ViewProj);
	OUT.Grid=float4(IN.Pos.xy-GridSize*0.5,0.0,Thickness+(OUT.Pos.w*ThicknessDepth));
	OUT.Box=float3(IN.Tex*2.0-1.0,(Thickness*2.5)+(OUT.Pos.z*ThicknessDepth*0.0025));
 	OUT.Tex=IN.Tex;
	OUT.Normal=normalize(mul(IN.Normal,World));
	OUT.vPos=mul(IN.Pos,World).xyz-ViewInv[3].xyz;
	OUT.Circle=float4(mul(IN.Pos,World).xz-World[3].xz,abs(mul(IN.Pos,World).x-World[3].x),Thickness+(OUT.Pos.z*ThicknessDepth));
	return OUT;
     }
   OutPut VS_Ortho(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=mul(mul(IN.Pos,World),OrthoProj);
	OUT.Grid=float4(IN.Pos.xy-GridSize*0.5,0.0,Thickness+(1*ThicknessDepth));
	OUT.Box=float3(IN.Tex*2.0-1.0,(Thickness*2.5)+(1*ThicknessDepth*0.0025));
 	OUT.Tex=IN.Tex;
	OUT.Normal=normalize(mul(IN.Normal,World));
	OUT.vPos=mul(IN.Pos,World).xyz-ViewInv[3].xyz;
	OUT.Circle=float4(mul(IN.Pos,World).xz-World[3].xz,abs(mul(IN.Pos,World).x-World[3].x),Thickness+(OUT.Pos.z*ThicknessDepth));
	return OUT;
     }
  
//--------------
// pixel shader
//--------------
    float4 PS_Grid(OutPut IN)  : COLOR
     {
	float l=frac(IN.Grid.x/GridSize);
	float a=1.0-saturate(abs(l*2.0-1.0)*(GridSize/IN.Grid.w));
	l=frac(IN.Grid.y/GridSize);
	float b=1.0-saturate(abs(l*2.0-1.0)*(GridSize/IN.Grid.w));
	float c=1.0-saturate(abs((IN.Grid.x+GridSize*0.5)*2.0)/IN.Grid.w);
	c +=1-saturate(abs((IN.Grid.y+GridSize*0.5)*2.0)/IN.Grid.w);
	return float4(vColor+c*0.5,((a+b)*0.25+c)*0.5*saturate(1-pow(length(IN.vPos/5000),0.25)));
     }
    float4 PS_Circle(OutPut IN)  : COLOR
     {
	float Circle=saturate(IN.Circle.z-length(IN.Circle.xy));
	Circle *=1.0-saturate((IN.Circle.z-IN.Circle.w)-length(IN.Circle.xy));
	return float4(vColor,Circle*0.5);
     }
    float4 PS_Box(OutPut IN)  : COLOR
     {
	float a=1-saturate((1-abs(IN.Box.x))/IN.Box.z);
	float b=1-saturate((1-abs(IN.Box.y))/IN.Box.z);
	a *=ceil(abs(IN.Box.y)-0.5);
	b *=ceil(abs(IN.Box.x)-0.5);
	return float4(vColor,sign(a+b));
     }

//--------------
// techniques   
//--------------
   technique Grid
      {
 	pass p0
      {		
	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS_Grid(); 	
      }
      }
   technique Circle
      {
 	pass p0
      {		
	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS_Circle(); 	
      }
      }
   technique GridOrtho
      {
 	pass p0
      {		
	vertexShader = compile vs_2_0 VS_Ortho(); 
 	pixelShader  = compile ps_2_0 PS_Grid(); 	
      }
      }
   technique Box
      {
 	pass p0
      {		
	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS_Box(); 	
      }
      }